<?php
/**
* Navigation for available actions when viewing a message that is not a draft.
*
* This partial is called by the main template for viewing the inbox ({@link template.php}), and will be contained in the .menu div.  
*
* @package direct-project-innovation-initiative
* @subpackage views
* @filesource
*/ /** */

?>
<div class="button-container unit size1of1 line">
	<div class="buttons unit">
		<button type="submit" class="minimal minimal-short" id="archive_btn" name="archive" style="width: 150px; <?php if($message->archived):?>visibility:hidden;<?php endif ?>">
			Archive Message
		</button>
	<?PHP if(isset($status_enabled) && $status_enabled === true): ?>
		<label for="assign_select" class="hidden_context">Select Group Member for Assign</label>
		<?php echo form_dropdown('assign_select', $group_members, null, 'id="assign_select" class="hidden_context"') ?>
		<input type="button" name="assign_select_btn_hidden" id="assign_select_btn_hidden" class="hidden_context" onclick="assign_selected($('#assign_select option:selected').val(),$('#assign_select option:selected').text());" value="Assign Select"/>
		<button type="button" id="assign_button" name="assign_button" class="minimal minimal-short"  aria-hidden="true">Assign &#x25BE;</button>
		<button type="button" name="complete_button"  id="complete_button"  class="minimal minimal-short" onclick="complete_current();" aria-hidden="true">Complete</button>
	<?php endif ?>			
	</div>
	<div class="action-buttons unit unit-right">
		<div class="button minimal minimal-short minimal-image">
			<a href="<?php echo site_url('inbox/compose/replyall/'.$message->id) ?>">
				<?php echo img(array('src' => 'images/replyall.png', 'alt' => 'Reply All', 'title' => 'Reply All')) ?>
			</a>
		</div>
		<div class="button minimal minimal-short minimal-image">
			<a href="<?php echo site_url('inbox/compose/reply/'.$message->id) ?>">
				<?php echo img(array('src' => 'images/reply.png', 'alt' => 'Reply', 'title' => 'Reply')) ?>
			</a>
		</div>
		<div class="button minimal minimal-short minimal-image">
			<a href="<?php echo site_url('inbox/compose/forward/'.$message->id) ?>">
				<?php echo img(array('src' => 'images/forward.png', 'alt' => 'Forward', 'title' => 'Forward')) ?>
			</a>
		</div>
	</div> 
</div>
                
